/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.internal;

import java.sql.SQLException;
import java.util.EventListener;
import oracle.jdbc.internal.ACProxyable;

public interface OracleStatement
extends oracle.jdbc.OracleStatement,
ACProxyable {
    public static final int DEFAULT_RSET_TYPE = 1;
    public static final int CLOSED = 0;
    public static final int ACTIVE = 1;
    public static final int CACHED = 2;
    public static final int NON_CACHED = 3;
    public static final byte IS_UNINITIALIZED = 0;
    public static final byte IS_SELECT = 1;
    public static final byte IS_DELETE = 2;
    public static final byte IS_INSERT = 4;
    public static final byte IS_MERGE = 8;
    public static final byte IS_UPDATE = 16;
    public static final byte IS_PLSQL_BLOCK = 32;
    public static final byte IS_CALL_BLOCK = 64;
    public static final byte IS_OTHER = -128;
    public static final byte IS_DML = 30;
    public static final byte IS_PLSQL = 96;

    public void setFixedString(boolean var1);

    public boolean getFixedString();

    public int sendBatch() throws SQLException;

    public boolean getserverCursor();

    public int getcacheState();

    public int getstatementType();

    public SqlKind getSqlKind() throws SQLException;

    public long getChecksum() throws SQLException;

    public void registerBindChecksumListener(BindChecksumListener var1) throws SQLException;

    public void setSnapshotSCN(long var1) throws SQLException;

    public static interface BindChecksumListener
    extends EventListener {
        public boolean shouldContinue(long var1);
    }

    public static enum SqlKind {
        SELECT(false, false, true, false, 1),
        DELETE(false, true, false, false, 2),
        INSERT(false, true, false, false, 4),
        MERGE(false, true, false, false, 8),
        UPDATE(false, true, false, false, 16),
        PLSQL_BLOCK(true, false, false, false, 32),
        CALL_BLOCK(true, false, false, false, 64),
        SELECT_FOR_UPDATE(false, false, true, false, 1),
        ALTER_SESSION(false, false, false, true, -128),
        OTHER(false, false, false, true, -128),
        UNINITIALIZED(false, false, false, false, 0);

        private final boolean dml;
        private final boolean plsqlOrCall;
        private final boolean select;
        private final boolean other;
        private final byte kind;

        private SqlKind(boolean bl, boolean bl2, boolean bl3, boolean bl4, byte by) {
            this.dml = bl2;
            this.plsqlOrCall = bl;
            this.select = bl3;
            this.other = bl4;
            this.kind = by;
        }

        public static final SqlKind valueOf(byte by) {
            switch (by) {
                case 2: {
                    return DELETE;
                }
                case 4: {
                    return INSERT;
                }
                case 8: {
                    return MERGE;
                }
                case 16: {
                    return UPDATE;
                }
                case -128: {
                    return OTHER;
                }
                case 32: {
                    return PLSQL_BLOCK;
                }
                case 64: {
                    return CALL_BLOCK;
                }
                case 1: {
                    return SELECT;
                }
            }
            return UNINITIALIZED;
        }

        public boolean isPlsqlOrCall() {
            return this.plsqlOrCall;
        }

        public boolean isDML() {
            return this.dml;
        }

        public boolean isSELECT() {
            return this.select;
        }

        public boolean isOTHER() {
            return this.other;
        }

        public byte getKind() {
            return this.kind;
        }
    }
}

